<?php
/**
 * Plugin Name: Anna Easy META DESCRIPTION
 * Description: Simple addition of META DESCRIPTION to your pages and articles with automatic generation.
 * Version: 1.2
 * Author: Anna Nicole Kucerova --  See also: <a href="https://nicoledigital.cz" target="_blank">NicoleDigital Network</a> - Improve your website performance See also: <a href="https://www.nicoledigital.cz/novyprojekt/" target="_blank">Eshop struggle help</a>
 */

if (!defined('ABSPATH')) {
    exit;
}

// Adding a custom field to the editor
function meta_description_box() {
    add_meta_box(
        'meta_description_box',
        'Meta Description',
        'meta_description_field',
        ['post', 'page'],
        'normal',
        'high'
    );
}
add_action('add_meta_boxes', 'meta_description_box');

function meta_description_field($post) {
    $value = get_post_meta($post->ID, '_meta_description', true);
    echo '<label for="meta_description">Enter meta description - recomended up to 160/940 pixels  (leave empty for automatic generation):</label>';
    echo '<textarea id="meta_description" name="meta_description" rows="3" style="width:100%;">' . esc_textarea($value) . '</textarea>';
}

// Function to automatically generate meta description
function generate_meta_description($content, $max_length = 160) {
    $content = wp_strip_all_tags($content);
    $content = preg_replace('/\s+/', ' ', $content);
    $description = substr($content, 0, $max_length);
    return esc_attr($description);
}

// Saving the meta description
function save_meta_description($post_id) {
    if (array_key_exists('meta_description', $_POST) && !empty($_POST['meta_description'])) {
        update_post_meta($post_id, '_meta_description', sanitize_text_field($_POST['meta_description']));
    } else {
        $post = get_post($post_id);
        $generated_description = generate_meta_description($post->post_content);
        update_post_meta($post_id, '_meta_description', $generated_description);
    }
}
add_action('save_post', 'save_meta_description');

// Adding meta description to the <head>
function insert_meta_description() {
    if (is_single() || is_page()) {
        global $post;
        $meta_description = get_post_meta($post->ID, '_meta_description', true);
        if ($meta_description) {
            echo '<meta name="description" content="' . esc_attr($meta_description) . '">' . "\n";
        }
    }
}
add_action('wp_head', 'insert_meta_description');
